 <?php
 
// Adiciona o container nas páginas de categorias de produtos, exibição de produtos e checkout
add_action('woocommerce_before_main_content', 'abrir_container_produto_categoria', 5);
function abrir_container_produto_categoria() {
    if (is_product_category() || is_shop()) {
        echo '<div class="container">';
    }
}

// Fecha o container nas páginas de categorias de produtos, exibição de produtos e checkout
add_action('woocommerce_after_main_content', 'fechar_container_produto_categoria', 15);
function fechar_container_produto_categoria() {
    if (is_product_category() || is_shop()) {
        echo '</div>';
    }
}

// Adiciona o container na página de checkout
add_action('woocommerce_before_checkout_form', 'abrir_container_checkout', 5);
function abrir_container_checkout() {
    if (is_checkout()) {
        echo '<div class="container">';
    }
}

// Fecha o container na página de checkout
add_action('woocommerce_after_checkout_form', 'fechar_container_checkout', 15);
function fechar_container_checkout() {
    if (is_checkout()) {
        echo '</div>';
    }
}




// Adicionar campo de seleção de role no formulário de registro
add_action( 'woocommerce_register_form', 'custom_woocommerce_role_select_field' );
function custom_woocommerce_role_select_field() {
    ?>
    <p class="form-row form-row-wide">
        <label for="role"><?php _e( 'Selecione seu Tipo de Conta', 'woocommerce' ); ?> <span class="required">*</span></label>
        <select name="role" id="role" class="input-select">
            <option value=""><?php _e( 'Selecione uma função', 'woocommerce' ); ?></option>
            <option value="customer"><?php _e( 'Cliente', 'woocommerce' ); ?></option>
            <option value="Distribuidor"><?php _e( 'Distribuidor', 'woocommerce' ); ?></option>
        </select>
    </p>
    <?php
}

// Validar a seleção de role no formulário de registro
add_action( 'woocommerce_register_post', 'custom_validate_role_field', 10, 3 );
function custom_validate_role_field( $username, $email, $validation_errors ) {
    if ( isset( $_POST['role'] ) && empty( $_POST['role'] ) ) {
        $validation_errors->add( 'role_error', __( 'Por favor, selecione um tipo de conta.', 'woocommerce' ) );
    }
    return $validation_errors;
}

// Salvar a role selecionada durante o registro
add_action( 'woocommerce_created_customer', 'custom_save_role_field' );
function custom_save_role_field( $customer_id ) {
    if ( isset( $_POST['role'] ) && ! empty( $_POST['role'] ) ) {
        $selected_role = sanitize_text_field( $_POST['role'] );

        // Verifica se o papel selecionado é 'customer' ou 'Distribuidor'
        if ( in_array( $selected_role, array( 'customer', 'Distribuidor' ) ) ) {
            $user = new WP_User( $customer_id );
            $user->set_role( $selected_role ); // Atribui o papel selecionado
        }
    }
}


function add_search_post_type_script() {
    ?>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            const searchForm = document.querySelector('form.hfe-search-button-wrapper');

            if (searchForm) {
                // Cria um campo oculto para forçar o post_type como product
                const hiddenInput = document.createElement("input");
                hiddenInput.type = "hidden";
                hiddenInput.name = "post_type";
                hiddenInput.value = "product";
                
                // Adiciona o campo oculto ao formulário de busca
                searchForm.appendChild(hiddenInput);
            }
        });
    </script>
    <?php
}
add_action('wp_footer', 'add_search_post_type_script');


// Habilita o suporte para oEmbed no tema
function mytheme_oembed_support() {
    add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'mytheme_oembed_support' );



// Adiciona o campo "aprovado" ao perfil do usuário
add_action('show_user_profile', 'add_aprovado_field');
add_action('edit_user_profile', 'add_aprovado_field');

function add_aprovado_field($user) {
    if (in_array('Distribuidor', (array) $user->roles)) {
        ?>
        <h3>Informações Distribuidor</h3>
        <table class="form-table">
            <tr>
                <th><label for="aprovado">Aprovado</label></th>
                <td>
                    <input type="checkbox" name="aprovado" id="aprovado" value="1" <?php checked(get_user_meta($user->ID, 'aprovado', true), '1'); ?> />
                    <span class="description">Marque se o Distribuidor estiver aprovado.</span>
                </td>
            </tr>
        </table>
        <?php
    }
}

// Salva o campo "aprovado"
add_action('personal_options_update', 'save_aprovado_field');
add_action('edit_user_profile_update', 'save_aprovado_field');

function save_aprovado_field($user_id) {
    if (current_user_can('edit_user', $user_id)) {
        $aprovado = isset($_POST['aprovado']) ? '1' : '0';
        update_user_meta($user_id, 'aprovado', $aprovado);
    }
}

if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title' 	=> 'Personalizar',
		'menu_title'	=> 'Personalizar',
		'menu_slug' 	=> 'painel-de-controle',
		'capability'	=> 'edit_posts',
		'icon_url'   => 'dashicons-admin-settings',
		'update_button'		=> __('Salvar', 'acf'),
		'redirect'		=> true,
		'position' => 3
	));

}

// Função para verificar se o usuário é Distribuidor e o valor mínimo de compra
function verificar_limite_compra_acf() {
    if (current_user_can('Distribuidor')) {
        $limite_compra = get_field('limite_compra', 'option');
        $total_carrinho = WC()->cart->total;

        if ($total_carrinho < $limite_compra) {
            ?>
            <style>
                .checkout-button { pointer-events: none; opacity: 0.5; }
            </style>
            <div class="woocommerce-error">
                <?php echo 'Você precisa atingir um valor mínimo de R$' . wc_price($limite_compra) . ' para concluir a compra.'; ?>
            </div>
            <?php
        }
    }
}
add_action('woocommerce_review_order_before_submit', 'verificar_limite_compra_acf', 10);

// Adicionar script para monitorar atualização do carrinho via AJAX
function adicionar_script_verificacao_limite() {
    if (current_user_can('Distribuidor')) {
    ?>
    <script type="text/javascript">
        jQuery(function($) {
            // Função para desabilitar o botão de checkout se o limite não for atingido
            function verificarLimiteCompra() {
                var limiteCompra = <?php echo get_field('limite_compra', 'option'); ?>;
                var totalCarrinho = parseFloat($('.order-total .woocommerce-Price-amount').text().replace(/[^0-9,.]/g, '').replace(',', '.'));

                if (totalCarrinho < limiteCompra) {
                    // Desabilita o botão de checkout
                    $('.checkout-button').css('pointer-events', 'none').css('opacity', '0.5');
                    if (!$('.woocommerce-error').length) {
                        $('<div class="woocommerce-error">Você precisa atingir um valor mínimo de R$' + limiteCompra.toFixed(2) + ' para concluir a compra.</div>').insertBefore('.checkout-button');
                    }
                } else {
                    // Reabilita o botão se o limite for atingido
                    $('.checkout-button').css('pointer-events', 'auto').css('opacity', '1');
                    $('.woocommerce-error').remove();
                }
            }

            // Rodar a verificação inicialmente
            verificarLimiteCompra();

            // Rodar novamente após a atualização do carrinho via AJAX
            $(document.body).on('updated_cart_totals', function() {
                verificarLimiteCompra();
            });
        });
    </script>
    <?php
    }
}
add_action('wp_footer', 'adicionar_script_verificacao_limite');


// Redirecionar "Distribuidor" para o carrinho se o valor mínimo não for atingido
function redirecionar_loja_se_valor_minimo() {
    // Verifica se o usuário tem a role 'Distribuidor' e se está tentando acessar a página de checkout
    if (current_user_can('Distribuidor') && is_checkout() && !is_wc_endpoint_url('order-received')) {
        // Recupera o valor do campo ACF 'limite_compra'
        $limite_compra = get_field('limite_compra', 'option');
        $total_carrinho = WC()->cart->total;

        // Se o valor do carrinho for menor que o limite, redireciona para a página do carrinho
        if ($total_carrinho < $limite_compra) {
            // Redireciona diretamente para a página do carrinho
            wp_safe_redirect(wc_get_cart_url());
            exit;
        }
    }
}
add_action('template_redirect', 'redirecionar_loja_se_valor_minimo');




// Adiciona uma nova coluna à lista de usuários
add_filter('manage_users_columns', 'add_aprovado_column');
function add_aprovado_column($columns) {
    $columns['aprovado'] = 'Aprovado';
    return $columns;
}

// Preenche a nova coluna com o valor correspondente e aplica classes CSS à linha
add_filter('manage_users_custom_column', 'show_aprovado_column_content', 10, 3);
function show_aprovado_column_content($output, $column_name, $user_id) {
    if ('aprovado' === $column_name) {
        $aprovado = get_user_meta($user_id, 'aprovado', true);
        $output = $aprovado === '1' ? 'Sim' : 'Não';
    }
    return $output;
}



//Ocultar preços e botões para Distribuidors não aprovados
function ocultar_precos_para_Distribuidors_nao_aprovados() {
    // Verifica se o usuário logado tem a role 'Distribuidor'
    if (current_user_can('Distribuidor')) {
        
        $usuario_atual = wp_get_current_user();
        $aprovado = get_user_meta($usuario_atual->ID, 'aprovado', true);
        
        // Se o Distribuidor não estiver aprovado
        if (empty($aprovado)) {
            // Remove o preço na página de produto simples e listagens
            add_filter('woocommerce_get_price_html', '__return_empty_string', 10, 2);
            add_filter('woocommerce_variable_price_html', '__return_empty_string', 10, 2); // Para produtos variáveis
            add_filter('woocommerce_variation_sale_price_html', '__return_empty_string', 10, 2); // Para variações

            // Forçar remoção de preços para produtos simples
            add_action('woocommerce_single_product_summary', function() {
                remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
            }, 9);

            // Remove o preço no carrinho e durante o checkout
            add_filter('woocommerce_cart_item_price', '__return_empty_string', 10, 3);
            add_filter('woocommerce_cart_item_subtotal', '__return_empty_string', 10, 3);

            // Remover o botão de adicionar ao carrinho no loop de produtos
            remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);

            // Remover o preço na página de categorias e listagens de produtos
            add_action('woocommerce_after_shop_loop_item_title', function() {
                remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
            }, 9);

            // Remover o botão de adicionar ao carrinho na página do produto
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);

            // Adicionar mensagem na página de produto
            add_action('woocommerce_single_product_summary', function() {
                echo '<p class="woocommerce-info">Seu cadastro está aguardando aprovação. Você não pode comprar no momento.</p>';
            }, 20);

            // Adicionar mensagem na listagem de produtos (loja/categoria)
            add_action('woocommerce_after_shop_loop_item_title', function() {
                echo '<p class="woocommerce-info">Seu cadastro está aguardando aprovação. Você não pode comprar no momento.</p>';
            }, 20);
        }
    }
}
add_action('wp', 'ocultar_precos_para_Distribuidors_nao_aprovados');










// Função para alterar a exibição de usuários no admin e destacar os não aprovados
add_filter('manage_users_custom_column', 'add_row_class', 10, 3);
function add_row_class($output, $column_name, $user_id) {
    if ('aprovado' === $column_name) {
        $aprovado = get_user_meta($user_id, 'aprovado', true);
        $class = ($aprovado === '1') ? 'aprovado' : 'nao-aprovado';
        
        // Adiciona a classe diretamente à linha do usuário
        echo '<style>
            #user-' . esc_attr($user_id) . ' {
                background-color: ' . ($class === 'aprovado' ? '#dff0d8' : '#f2dede') . ';
            }
        </style>';
    }
    return $output;
}



// Adicionar classe ao body para verificar aprovação de Distribuidor
add_filter( 'body_class', 'adicionar_classe_para_loja_aprovada' );
function adicionar_classe_para_loja_aprovada( $classes ) {
    if ( current_user_can( 'Distribuidor' ) ) {
        $usuario_atual = wp_get_current_user();
        $aprovado = get_user_meta( $usuario_atual->ID, 'aprovado', true );

        if ( empty( $aprovado ) ) {
            // Adiciona a classe 'Distribuidor-nao-aprovado' ao body
            $classes[] = 'Distribuidor-nao-aprovado';
        } else {
            // Adiciona a classe 'Distribuidor-aprovado' ao body
            $classes[] = 'Distribuidor-aprovado';
        }
    }
    
    return $classes;
}

add_action( 'wp_head', 'desabilitar_precos_e_botoes_para_produtos_simples_e_variaveis' );
function desabilitar_precos_e_botoes_para_produtos_simples_e_variaveis() {
    ?>
    <style>
        /* Esconder o preço rapidamente para produtos simples */
        body.Distribuidor-nao-aprovado .product-type-simple .price,
        body.Distribuidor-nao-aprovado .product-type-simple .woocommerce-Price-amount {
            display: none;
        }
        /* Estilizar os botões desabilitados */
        body.Distribuidor-nao-aprovado .product-type-simple .add_to_cart_button.disabled,
        body.Distribuidor-nao-aprovado .product-type-simple .single_add_to_cart_button.disabled,
        body.Distribuidor-nao-aprovado .product-type-variable .button.disabled {
            pointer-events: none; /* Previne clique */
            opacity: 0.5; /* Visualmente desabilitado */
            cursor: not-allowed; /* Cursor de não permitido */
        }
    </style>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            // Verifica se o body tem a classe 'Distribuidor-nao-aprovado'
            if (document.body.classList.contains('Distribuidor-nao-aprovado')) {
                // Remove o HTML do preço para produtos simples
                var priceElementsSimple = document.querySelectorAll('.product-type-simple .price, .product-type-simple .woocommerce-Price-amount');
                priceElementsSimple.forEach(function(element) {
                    element.remove(); // Remove o elemento de preço do DOM
                });

                // Remove o HTML do preço para produtos variáveis
                var priceElementsVariable = document.querySelectorAll('.product-type-variable .price, .product-type-variable .woocommerce-Price-amount');
                priceElementsVariable.forEach(function(element) {
                    element.remove(); // Remove o elemento de preço do DOM
                });

                // Desabilita os botões de adicionar ao carrinho para produtos simples
                var addToCartButtons = document.querySelectorAll('.product-type-simple .add_to_cart_button, .product-type-simple .single_add_to_cart_button');
                addToCartButtons.forEach(function(button) {
                    button.classList.add('disabled'); // Adiciona classe de desabilitado
                    button.setAttribute('disabled', 'disabled'); // Define atributo disabled
                    button.innerHTML = 'Aguardando aprovação'; // Opcional: altera o texto do botão
                });

                // Desabilita o botão "Selecionar Opções" para produtos variáveis
                var variableProductButtons = document.querySelectorAll('.product-type-variable .button');
                variableProductButtons.forEach(function(button) {
                    button.classList.add('disabled'); // Adiciona classe de desabilitado
                    button.setAttribute('disabled', 'disabled'); // Define atributo disabled
                    button.innerHTML = 'Aguardando aprovação'; // Opcional: altera o texto do botão
                });
            }
        });
    </script>
    <?php
}


?>




